/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class StartAndStopRoutesTest
extends ContextTestSupport {
    protected Endpoint endpointA;
    protected Endpoint endpointB;
    protected Endpoint endpointC;
    protected final Object expectedBody = "<hello>world!</hello>";

    @Test
    public void testStartRouteThenStopMutateAndStartRouteAgain() throws Exception {
        List routes = this.context.getRouteDefinitions();
        StartAndStopRoutesTest.assertCollectionSize("Route", routes, 1);
        RouteDefinition route = (RouteDefinition)routes.get(0);
        this.endpointA = this.getMandatoryEndpoint("direct:test.a");
        this.endpointB = this.getMandatoryEndpoint("seda:test.b");
        this.endpointC = this.getMandatoryEndpoint("direct:test.C");
        MockEndpoint results = this.getMockEndpoint("mock:results");
        results.expectedBodiesReceived(new Object[]{this.expectedBody});
        this.template.sendBody(this.endpointA, this.expectedBody);
        this.assertMockEndpointsSatisfied();
        this.context.getRouteController().stopRoute(route.getId());
        FromDefinition fromType = route.getInput();
        fromType.setUri("direct:test.C");
        ((Model)this.context.getCamelContextExtension().getContextPlugin(Model.class)).addRouteDefinition(route);
        results.reset();
        results = this.getMockEndpoint("mock:results");
        results.expectedBodiesReceived(new Object[]{this.expectedBody});
        this.template.sendBody(this.endpointC, this.expectedBody);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:test.a").to("seda:test.b")).to("mock:results");
            }
        };
    }
}

