/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleShutdownGracefulNoAtuoStartedTest
extends ContextTestSupport {
    private static String foo = "";

    @Test
    public void testShutdownGraceful() throws Exception {
        this.context.getRouteController().startRoute("foo");
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        foo = foo + "stop";
        this.context.stop();
        Assertions.assertEquals((Object)"stopHello World", (Object)foo, (String)"Should graceful shutdown");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").autoStartup(false).to("mock:foo")).delay(3000L).process(new Processor(){

                    public void process(Exchange exchange) {
                        foo = foo + (String)exchange.getIn().getBody(String.class);
                    }
                });
            }
        };
    }
}

