/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.support.SimpleRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SimpleRegistryWrapTest {
    private final SimpleRegistry registry = new SimpleRegistry(){

        public Object wrap(Object value) {
            return "wrap" + String.valueOf(value);
        }

        public Object unwrap(Object value) {
            return "unwrap" + String.valueOf(value);
        }
    };

    @BeforeEach
    public void setUp() {
        this.registry.bind("a", (Object)"123");
        this.registry.bind("b", (Object)"456");
    }

    @Test
    public void testLookupByName() {
        Assertions.assertEquals((Object)"unwrapwrap123", (Object)this.registry.lookupByName("a"));
    }

    @Test
    public void testLookupByNameAndType() {
        Assertions.assertEquals((Object)"unwrapwrap456", (Object)this.registry.lookupByNameAndType("b", String.class));
    }

    @Test
    public void testLookupByType() {
        Map map = this.registry.findByTypeWithName(String.class);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((Object)"unwrapwrap123", map.get("a"));
        Assertions.assertEquals((Object)"unwrapwrap456", map.get("b"));
    }
}

