/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.support.SimpleRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SimpleRegistryTest {
    private SimpleRegistry registry;

    @BeforeEach
    public void setUp() {
        this.registry = new SimpleRegistry();
        this.registry.bind("a", (Object)"b");
        this.registry.bind("c", (Object)1);
    }

    @Test
    public void testLookupByName() {
        Assertions.assertEquals((Object)"b", (Object)this.registry.lookupByName("a"));
    }

    @Test
    public void testLookupByWrongName() {
        Assertions.assertNull((Object)this.registry.lookupByName("x"));
    }

    @Test
    public void testLookupByNameAndType() {
        Assertions.assertEquals((Object)"b", (Object)this.registry.lookupByNameAndType("a", String.class));
    }

    @Test
    public void testLookupByNameAndWrongType() {
        Object answer = this.registry.lookupByNameAndType("a", Float.class);
        Assertions.assertNull((Object)answer);
    }

    @Test
    public void testLookupByType() {
        Map map = this.registry.findByTypeWithName(String.class);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)"b", map.get("a"));
        map = this.registry.findByTypeWithName(Object.class);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((Object)"b", map.get("a"));
        Assertions.assertEquals((Object)1, map.get("c"));
    }

    @Test
    public void testLookupByWrongType() {
        Map map = this.registry.findByTypeWithName(Float.class);
        Assertions.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void testBindDual() {
        String foo = "foo";
        this.registry.bind("c", (Object)foo);
        Assertions.assertEquals((int)2, (int)this.registry.size());
        Assertions.assertSame((Object)1, (Object)this.registry.lookupByName("c"));
        Assertions.assertSame((Object)1, (Object)this.registry.lookupByNameAndType("c", Integer.class));
        Assertions.assertSame((Object)"foo", (Object)this.registry.lookupByNameAndType("c", String.class));
        Map map = this.registry.findByTypeWithName(Integer.class);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)map.get("c")));
        Map map2 = this.registry.findByTypeWithName(String.class);
        Assertions.assertEquals((int)2, (int)map2.size());
        Assertions.assertEquals((Object)"foo", map2.get("c"));
        Assertions.assertEquals((Object)"b", map2.get("a"));
    }

    @Test
    public void testBindChange() {
        String foo = "foo";
        this.registry.bind("myKey", (Object)foo);
        Assertions.assertEquals((Object)"foo", (Object)this.registry.lookupByName("myKey"));
        String bar = "bar";
        this.registry.bind("myKey", (Object)bar);
        Assertions.assertEquals((Object)"bar", (Object)this.registry.lookupByName("myKey"));
    }

    @Test
    public void testUnbind() {
        String foo = "foo";
        this.registry.bind("myKey", (Object)foo);
        Assertions.assertEquals((Object)"foo", (Object)this.registry.lookupByName("myKey"));
        this.registry.unbind("myKey");
        Assertions.assertNull((Object)this.registry.lookupByName("myKey"));
        String bar = "bar";
        this.registry.bind("myKey", (Object)bar);
        Assertions.assertEquals((Object)"bar", (Object)this.registry.lookupByName("myKey"));
    }
}

