/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShutdownGracefulTimeoutTriggerTest
extends ContextTestSupport {
    private static String foo = "";

    @Test
    public void testShutdownGraceful() throws Exception {
        this.context.getShutdownStrategy().setTimeout(2L);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"A");
        this.template.sendBody("seda:foo", (Object)"B");
        this.template.sendBody("seda:foo", (Object)"C");
        this.template.sendBody("seda:foo", (Object)"D");
        this.template.sendBody("seda:foo", (Object)"E");
        this.assertMockEndpointsSatisfied();
        foo = foo + "stop";
        this.context.stop();
        Assertions.assertNotSame((Object)"Should not able able to complete all pending messages", (Object)foo, (String)"stopABCDE");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").to("mock:foo")).delay(1000L).process(new Processor(){

                    public void process(Exchange exchange) {
                        foo = foo + (String)exchange.getIn().getBody(String.class);
                    }
                });
            }
        };
    }
}

