/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShutdownGracefulNoAutoStartedRoutesTest
extends ContextTestSupport {
    @Test
    public void testShutdownGraceful() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.context.getRouteController().startRoute("bar");
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.template.sendBody("direct:bar", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStopped(), (String)"Route foo should be stopped");
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("bar").isStopped(), (String)"Route bar should be stopped");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:foo").routeId("foo").to("mock:foo");
                this.from("direct:bar").routeId("bar").autoStartup(false).to("mock:bar");
            }
        };
    }
}

