/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.support.ShortUuidGenerator;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortUuidGeneratorTest {
    private static final Logger LOG = LoggerFactory.getLogger(ShortUuidGeneratorTest.class);

    @Test
    public void testGenerateUUID() {
        ShortUuidGenerator uuidGenerator = new ShortUuidGenerator();
        String firstUUID = uuidGenerator.generateUuid();
        String secondUUID = uuidGenerator.generateUuid();
        Assertions.assertNotSame((Object)firstUUID, (Object)secondUUID);
    }

    @Test
    public void testPerformance() {
        ShortUuidGenerator uuidGenerator = new ShortUuidGenerator();
        StopWatch watch = new StopWatch();
        LOG.info("First id: {}", (Object)uuidGenerator.generateUuid());
        for (int i = 0; i < 500000; ++i) {
            uuidGenerator.generateUuid();
        }
        LOG.info("Last id: {}", (Object)uuidGenerator.generateUuid());
        LOG.info("Took {}", (Object)TimeUtils.printDuration((long)watch.taken(), (boolean)true));
    }
}

