/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.MockScheduledPollConsumer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScheduledPollConsumerTest
extends ContextTestSupport {
    private static boolean rollback;
    private static String event;

    @Test
    public void testExceptionOnPollAndCanStartAgain() {
        final Exception expectedException = new Exception("Hello, I should be thrown on shutdown only!");
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) {
                if (e == expectedException) {
                    rollback = true;
                }
                return false;
            }
        });
        consumer.start();
        consumer.run();
        consumer.stop();
        Assertions.assertTrue((boolean)rollback, (String)"Should have rollback");
        rollback = false;
        consumer.setExceptionToThrowOnPoll(null);
        consumer.start();
        consumer.run();
        consumer.stop();
        Assertions.assertFalse((boolean)rollback, (String)"Should not have rollback");
    }

    @Test
    public void testRetryAtMostThreeTimes() {
        final AtomicInteger counter = new AtomicInteger();
        event = "";
        Exception expectedException = new Exception("Hello, I should be thrown on shutdown only!");
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
                event = event + "commit";
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) {
                event = event + "rollback";
                int cnt = counter.incrementAndGet();
                return cnt <= 3;
            }
        });
        consumer.setUseFixedDelay(true);
        consumer.setDelay(60000L);
        consumer.start();
        consumer.run();
        consumer.stop();
        Assertions.assertEquals((int)4, (int)counter.get());
        Assertions.assertEquals((Object)"rollbackrollbackrollbackrollback", (Object)event);
    }

    @Test
    public void testNoExceptionOnPoll() {
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, null);
        consumer.start();
        consumer.run();
        consumer.stop();
    }

    static {
        event = "";
    }
}

