/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.Mock321ScheduledPollConsumer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScheduledPollConsumerGreedyTest
extends ContextTestSupport {
    private final AtomicInteger polled = new AtomicInteger();

    @Test
    public void test321Greedy() {
        this.polled.set(0);
        Mock321ScheduledPollConsumer consumer = new Mock321ScheduledPollConsumer((DefaultEndpoint)this.getMockEndpoint("mock:foo"), null);
        consumer.setGreedy(true);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
                ScheduledPollConsumerGreedyTest.this.polled.addAndGet(polledMessages);
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) {
                return false;
            }
        });
        consumer.start();
        consumer.run();
        Assertions.assertEquals((int)6, (int)this.polled.get());
        consumer.stop();
    }

    @Test
    public void test321NotGreedy() {
        this.polled.set(0);
        Mock321ScheduledPollConsumer consumer = new Mock321ScheduledPollConsumer((DefaultEndpoint)this.getMockEndpoint("mock:foo"), null);
        consumer.setGreedy(false);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
                ScheduledPollConsumerGreedyTest.this.polled.addAndGet(polledMessages);
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) {
                return false;
            }
        });
        consumer.start();
        consumer.run();
        Assertions.assertEquals((int)3, (int)this.polled.get());
        consumer.run();
        Assertions.assertEquals((int)5, (int)this.polled.get());
        consumer.run();
        Assertions.assertEquals((int)6, (int)this.polled.get());
        consumer.run();
        Assertions.assertEquals((int)6, (int)this.polled.get());
        consumer.stop();
    }
}

