/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.MockScheduledPollConsumer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class ScheduledPollConsumerBackoffTest
extends ContextTestSupport {
    private static int commits;
    private static int errors;

    @Test
    public void testBackoffIdle() {
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = ScheduledPollConsumerBackoffTest.createMockScheduledPollConsumer((Endpoint)endpoint);
        consumer.run();
        consumer.run();
        Assertions.assertEquals((int)2, (int)commits);
        consumer.run();
        consumer.run();
        consumer.run();
        consumer.run();
        Assertions.assertEquals((int)3, (int)commits);
        consumer.run();
        consumer.run();
        Assertions.assertEquals((int)4, (int)commits);
        consumer.run();
        consumer.run();
        consumer.run();
        consumer.run();
        Assertions.assertEquals((int)6, (int)commits);
        consumer.run();
        Assertions.assertEquals((int)6, (int)commits);
        consumer.stop();
    }

    @Test
    public void testBackoffError() {
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        Exception expectedException = new Exception("Hello, I should be thrown on shutdown only!");
        MockScheduledPollConsumer consumer = ScheduledPollConsumerBackoffTest.createMockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.run();
        consumer.run();
        consumer.run();
        Assertions.assertEquals((int)3, (int)errors);
        consumer.run();
        consumer.run();
        consumer.run();
        consumer.run();
        Assertions.assertEquals((int)4, (int)errors);
        consumer.run();
        consumer.run();
        consumer.run();
        Assertions.assertEquals((int)6, (int)errors);
        consumer.run();
        consumer.run();
        consumer.run();
        consumer.run();
        Assertions.assertEquals((int)8, (int)errors);
        consumer.stop();
    }

    private static MockScheduledPollConsumer createMockScheduledPollConsumer(Endpoint endpoint, Exception expectedException) {
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer(endpoint, expectedException);
        consumer.setBackoffMultiplier(4);
        consumer.setBackoffErrorThreshold(3);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
                ++commits;
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) {
                ++errors;
                return false;
            }
        });
        consumer.start();
        return consumer;
    }

    private static MockScheduledPollConsumer createMockScheduledPollConsumer(Endpoint endpoint) {
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer(endpoint, null);
        consumer.setBackoffMultiplier(4);
        consumer.setBackoffIdleThreshold(2);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
                ++commits;
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) {
                return false;
            }
        });
        consumer.start();
        return consumer;
    }
}

