/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.engine.DefaultRuntimeEndpointRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RuntimeEndpointRegistryTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        camelContext.setRuntimeEndpointRegistry((RuntimeEndpointRegistry)new DefaultRuntimeEndpointRegistry());
        return camelContext;
    }

    @Test
    public void testRuntimeEndpointRegistry() throws Exception {
        RuntimeEndpointRegistry registry = this.context.getRuntimeEndpointRegistry();
        Assertions.assertEquals((int)0, (int)registry.getAllEndpoints(false).size());
        Assertions.assertEquals((int)2, (int)registry.getAllEndpoints(true).size());
        MockEndpoint mock = this.getMockEndpoint("mock:foo2");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("seda:foo", (Object)"Hello World", "slip", (Object)"mock:foo2");
        mock.assertIsSatisfied();
        Assertions.assertEquals((int)4, (int)registry.getAllEndpoints(true).size());
        Assertions.assertEquals((int)3, (int)registry.getEndpointsPerRoute("foo", true).size());
        Assertions.assertEquals((int)1, (int)registry.getEndpointsPerRoute("bar", true).size());
        mock = this.getMockEndpoint("mock:bar2");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("seda:bar", (Object)"Bye World", "slip", (Object)"mock:bar2");
        mock.assertIsSatisfied();
        Assertions.assertEquals((int)6, (int)registry.getAllEndpoints(true).size());
        Assertions.assertEquals((int)3, (int)registry.getEndpointsPerRoute("foo", true).size());
        Assertions.assertEquals((int)3, (int)registry.getEndpointsPerRoute("bar", true).size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("mock:foo")).recipientList((Expression)this.header("slip"));
                ((RouteDefinition)this.from("seda:bar").routeId("bar").to("mock:bar")).recipientList((Expression)this.header("slip"));
            }
        };
    }
}

