/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.StatefulService;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteSedaSuspendResumeTest
extends ContextTestSupport {
    @Test
    public void testSuspendResume() throws Exception {
        StatefulService statefulService;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        this.log.info("Suspending");
        this.resetMocks();
        mock.expectedMessageCount(0);
        this.context.getRouteController().suspendRoute("foo");
        Assertions.assertEquals((Object)"Suspended", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        Route route = this.context.getRoute("foo");
        if (route instanceof StatefulService) {
            statefulService = (StatefulService)route;
            Assertions.assertEquals((Object)"Suspended", (Object)statefulService.getStatus().name());
        }
        Thread.sleep(1000L);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> ((SedaEndpoint)this.context.getEndpoint("seda:foo", SedaEndpoint.class)).getQueue().isEmpty());
        this.template.sendBody("seda:foo", (Object)"B");
        mock.assertIsSatisfied(100L);
        this.log.info("Resuming");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"B"});
        this.context.getRouteController().resumeRoute("foo");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        route = this.context.getRoute("foo");
        if (route instanceof StatefulService) {
            statefulService = (StatefulService)route;
            Assertions.assertEquals((Object)"Started", (Object)statefulService.getStatus().name());
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

