/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.StatefulService;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteSedaStopStartTest
extends ContextTestSupport {
    @Test
    public void testStopStart() throws Exception {
        StatefulService statefulService;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        this.log.info("Stopping");
        this.resetMocks();
        mock.expectedMessageCount(0);
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        Route route = this.context.getRoute("foo");
        if (route instanceof StatefulService) {
            statefulService = (StatefulService)route;
            Assertions.assertEquals((Object)"Stopped", (Object)statefulService.getStatus().name());
        }
        this.template.sendBody("seda:foo", (Object)"B");
        mock.assertIsSatisfied(1000L);
        this.log.info("Starting");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"B"});
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        route = this.context.getRoute("foo");
        if (route instanceof StatefulService) {
            statefulService = (StatefulService)route;
            Assertions.assertEquals((Object)"Started", (Object)statefulService.getStatus().name());
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

