/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.engine.DefaultRoute;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteRemoveTest
extends ContextTestSupport {
    @Test
    public void testStopRouteOnContext() throws Exception {
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)((DefaultRoute)this.context.getRoute("foo")).getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("foo"));
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)((DefaultRoute)this.context.getRoute("foo")).getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteController().getRouteStatus("foo"));
    }

    @Test
    public void testRemove() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        boolean removed = this.context.removeRoute("foo");
        Assertions.assertFalse((boolean)removed);
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        this.context.getRouteController().stopRoute("foo");
        removed = this.context.removeRoute("foo");
        Assertions.assertTrue((boolean)removed);
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
        Assertions.assertNull((Object)this.context.getRouteController().getRouteStatus("foo"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

