/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.RoutePolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutePolicyTest
extends ContextTestSupport {
    private final MyRoutPolicy routePolicy = new MyRoutPolicy();

    @Test
    public void testStartCalledWhenCamelStarts() {
        Assertions.assertEquals((int)1, (int)this.routePolicy.getStartCount());
    }

    @Test
    public void testStartCalledWhenRouteStarts() throws Exception {
        Assertions.assertEquals((int)1, (int)this.routePolicy.getStartCount());
        this.context.getRouteController().stopRoute("foo");
        this.context.getRouteController().startRoute("foo");
        Assertions.assertEquals((int)2, (int)this.routePolicy.getStartCount());
    }

    @Test
    public void testStopCalledWhenCamelStops() throws Exception {
        Assertions.assertEquals((int)0, (int)this.routePolicy.getStopCount());
        this.stopCamelContext();
        Assertions.assertEquals((int)1, (int)this.routePolicy.getStopCount());
    }

    @Test
    public void testStopCalledWhenRouteStops() throws Exception {
        Assertions.assertEquals((int)0, (int)this.routePolicy.getStopCount());
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertEquals((int)1, (int)this.routePolicy.getStopCount());
    }

    @Test
    public void testSuspendCalledWhenRouteSuspends() throws Exception {
        Assertions.assertEquals((int)0, (int)this.routePolicy.getSuspendCount());
        this.context.getRouteController().suspendRoute("foo");
        Assertions.assertEquals((int)1, (int)this.routePolicy.getSuspendCount());
    }

    @Test
    public void testResumeCalledWhenRouteResumes() throws Exception {
        Assertions.assertEquals((int)0, (int)this.routePolicy.getResumeCount());
        this.context.getRouteController().suspendRoute("foo");
        this.context.getRouteController().resumeRoute("foo");
        Assertions.assertEquals((int)1, (int)this.routePolicy.getResumeCount());
    }

    @Test
    public void testRemoveCalledWhenRouteIsRemovedById() throws Exception {
        Assertions.assertEquals((int)0, (int)this.routePolicy.getRemoveCount());
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertEquals((int)0, (int)this.routePolicy.getRemoveCount());
        this.context.removeRoute("foo");
        Assertions.assertEquals((int)1, (int)this.routePolicy.getRemoveCount());
    }

    @Test
    public void testRemoveCalledWhenCamelIsStopped() {
        Assertions.assertTrue((boolean)this.context.getStatus().isStarted());
        Assertions.assertEquals((int)0, (int)this.routePolicy.getRemoveCount());
        this.context.stop();
        Assertions.assertTrue((boolean)this.context.getStatus().isStopped());
        Assertions.assertEquals((int)1, (int)this.routePolicy.getRemoveCount());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").routePolicy(new RoutePolicy[]{RoutePolicyTest.this.routePolicy}).to("mock:result");
            }
        };
    }

    private static class MyRoutPolicy
    implements RoutePolicy {
        private final AtomicInteger removeCounter = new AtomicInteger();
        private final AtomicInteger startCounter = new AtomicInteger();
        private final AtomicInteger stopCounter = new AtomicInteger();
        private final AtomicInteger suspendCounter = new AtomicInteger();
        private final AtomicInteger resumeCounter = new AtomicInteger();

        private MyRoutPolicy() {
        }

        public void onRemove(Route route) {
            this.removeCounter.incrementAndGet();
        }

        public void onStart(Route route) {
            this.startCounter.incrementAndGet();
        }

        public void onStop(Route route) {
            this.stopCounter.incrementAndGet();
        }

        public void onSuspend(Route route) {
            this.suspendCounter.incrementAndGet();
        }

        public void onResume(Route route) {
            this.resumeCounter.incrementAndGet();
        }

        public void onInit(Route route) {
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
        }

        public void onExchangeDone(Route route, Exchange exchange) {
        }

        private int getRemoveCount() {
            return this.removeCounter.get();
        }

        private int getStartCount() {
            return this.startCounter.get();
        }

        private int getStopCount() {
            return this.stopCounter.get();
        }

        private int getSuspendCount() {
            return this.suspendCounter.get();
        }

        private int getResumeCount() {
            return this.resumeCounter.get();
        }
    }
}

