/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutePolicySupportTest
extends ContextTestSupport {
    private final MyRoutePolicy policy = new MyRoutePolicy();

    @Test
    public void testLifecycleCallbacks() throws Exception {
        Route route = this.context.getRoute("foo");
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteController().getRouteStatus("foo"));
        this.policy.startRoute(route);
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("foo"));
        this.policy.suspendRoute(route);
        Assertions.assertEquals((Object)ServiceStatus.Suspended, (Object)this.context.getRouteController().getRouteStatus("foo"));
        this.policy.resumeRoute(route);
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("foo"));
        this.policy.stopRoute(route);
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteController().getRouteStatus("foo"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").routePolicy(new RoutePolicy[]{RoutePolicySupportTest.this.policy}).autoStartup(false).to("mock:result");
            }
        };
    }

    public static class MyRoutePolicy
    extends RoutePolicySupport {
    }
}

