/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutePolicyCallbackTest
extends ContextTestSupport {
    protected MyRoutePolicy policy = new MyRoutePolicy();

    protected MyRoutePolicy getAndInitMyRoutePolicy() {
        return this.policy;
    }

    @Test
    public void testCallback() throws Exception {
        this.policy = this.getAndInitMyRoutePolicy();
        Assertions.assertTrue((boolean)this.policy.doStart);
        Assertions.assertTrue((boolean)this.policy.init);
        Assertions.assertFalse((boolean)this.policy.begin);
        Assertions.assertFalse((boolean)this.policy.done);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.policy.begin);
        Assertions.assertTrue((boolean)this.policy.done);
        Assertions.assertFalse((boolean)this.policy.suspend);
        this.context.getRouteController().suspendRoute("foo");
        Assertions.assertTrue((boolean)this.policy.suspend);
        Assertions.assertFalse((boolean)this.policy.resume);
        this.context.getRouteController().resumeRoute("foo");
        Assertions.assertTrue((boolean)this.policy.resume);
        Assertions.assertFalse((boolean)this.policy.stop);
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertTrue((boolean)this.policy.stop);
        this.policy.start = false;
        Assertions.assertFalse((boolean)this.policy.start);
        this.context.getRouteController().startRoute("foo");
        Assertions.assertTrue((boolean)this.policy.start);
        Assertions.assertFalse((boolean)this.policy.remove);
        this.context.getRouteController().stopRoute("foo");
        this.context.removeRoute("foo");
        Assertions.assertTrue((boolean)this.policy.remove);
        this.context.stop();
        Assertions.assertTrue((boolean)this.policy.doStop);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").routePolicy(new RoutePolicy[]{RoutePolicyCallbackTest.this.policy}).to("mock:result");
            }
        };
    }

    public static class MyRoutePolicy
    extends RoutePolicySupport {
        boolean begin;
        boolean done;
        boolean init;
        boolean remove;
        boolean resume;
        boolean start;
        boolean stop;
        boolean suspend;
        boolean doStart;
        boolean doStop;

        public void onExchangeBegin(Route route, Exchange exchange) {
            this.begin = true;
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            this.done = true;
        }

        public void onInit(Route route) {
            this.init = true;
        }

        public void onRemove(Route route) {
            this.remove = true;
        }

        public void onResume(Route route) {
            this.resume = true;
        }

        public void onStart(Route route) {
            this.start = true;
        }

        public void onStop(Route route) {
            this.stop = true;
        }

        public void onSuspend(Route route) {
            this.suspend = true;
        }

        protected void doStop() {
            this.doStop = true;
        }

        protected void doStart() {
            this.doStart = true;
        }
    }
}

