/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.component.rest.DummyRestProcessorFactory;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteIdRestDefinitionTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        registry.bind("dummy-rest-api", (Object)new DummyRestProcessorFactory());
        return registry;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start1?timeout=30000").to("mock:result");
                this.from("direct:start2").to("mock:result");
                this.rest("/say/hello").get("/bar").id("getSayHelloBar").to("mock:result").get("/bar/{user}").id("getSayHelloBarWithUser").to("mock:result");
            }
        };
    }

    @Test
    public void testSayHelloBar() {
        Assertions.assertEquals((Object)"getSayHelloBar", (Object)((RouteDefinition)this.context.getRouteDefinitions().get(2)).getId());
        Assertions.assertEquals((Object)"getSayHelloBarWithUser", (Object)((RouteDefinition)this.context.getRouteDefinitions().get(3)).getId());
    }
}

