/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteDirectSuspendResumeTest
extends ContextTestSupport {
    @Test
    public void testSuspendResume() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("direct:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        this.log.info("Suspending");
        this.resetMocks();
        mock.expectedMessageCount(0);
        this.context.getRouteController().suspendRoute("foo");
        Assertions.assertEquals((Object)"Suspended", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:foo", (Object)"B"), (String)"Should have thrown an exception");
        this.log.info("Resuming");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"B"});
        this.context.getRouteController().resumeRoute("foo");
        this.template.sendBody("direct:foo", (Object)"B");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").name());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((DirectComponent)RouteDirectSuspendResumeTest.this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
                ((RouteDefinition)this.from("direct:foo").routeId("foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

