/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoveRouteStopEndpointTest
extends ContextTestSupport {
    @Test
    public void testEndpointRegistryStopRouteEndpoints() throws Exception {
        Endpoint seda = this.context.hasEndpoint("seda://foo");
        Assertions.assertNotNull((Object)seda);
        Endpoint log = this.context.hasEndpoint("log://bar");
        Assertions.assertNotNull((Object)log);
        Assertions.assertTrue((boolean)((ServiceSupport)seda).isStarted(), (String)"Should be started");
        Assertions.assertTrue((boolean)((ServiceSupport)log).isStarted(), (String)"Should be started");
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda:foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda:bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda://stop"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://stop"));
        this.context.getRouteController().stopRoute("bar");
        this.context.removeRoute("bar");
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNull((Object)this.context.hasEndpoint("seda://bar"));
        Assertions.assertNull((Object)this.context.hasEndpoint("log://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda://stop"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://stop"));
        Assertions.assertTrue((boolean)((ServiceSupport)seda).isStarted(), (String)"Should be started");
        Assertions.assertTrue((boolean)((ServiceSupport)log).isStopped(), (String)"Should be stopped");
        this.context.getRouteController().stopRoute("baz");
        this.context.removeRoute("baz");
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNull((Object)this.context.hasEndpoint("seda://bar"));
        Assertions.assertNull((Object)this.context.hasEndpoint("log://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
        Assertions.assertNull((Object)this.context.hasEndpoint("seda://stop"));
        Assertions.assertNull((Object)this.context.hasEndpoint("mock://stop"));
        this.context.getRouteController().stopRoute("foo");
        this.context.removeRoute("foo");
        Assertions.assertNull((Object)this.context.hasEndpoint("seda://foo"));
        Assertions.assertNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNull((Object)this.context.hasEndpoint("seda://bar"));
        Assertions.assertNull((Object)this.context.hasEndpoint("log://bar"));
        Assertions.assertNull((Object)this.context.hasEndpoint("mock://result"));
        Assertions.assertNull((Object)this.context.hasEndpoint("seda://stop"));
        Assertions.assertNull((Object)this.context.hasEndpoint("mock://stop"));
        Assertions.assertFalse((boolean)((ServiceSupport)seda).isStarted(), (String)"Should not be started");
        Assertions.assertFalse((boolean)((ServiceSupport)log).isStarted(), (String)"Should not be started");
    }

    @Test
    public void testEndpointRegistryStopRouteEndpointsContextStop() throws Exception {
        Endpoint seda = this.context.hasEndpoint("seda://foo");
        Assertions.assertNotNull((Object)seda);
        Endpoint log = this.context.hasEndpoint("log://bar");
        Assertions.assertNotNull((Object)log);
        Assertions.assertTrue((boolean)((ServiceSupport)seda).isStarted(), (String)"Should be started");
        Assertions.assertTrue((boolean)((ServiceSupport)log).isStarted(), (String)"Should be started");
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda://stop"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://stop"));
        this.context.getRouteController().stopRoute("bar");
        this.context.removeRoute("bar");
        Assertions.assertTrue((boolean)((ServiceSupport)seda).isStarted(), (String)"Should be started");
        Assertions.assertTrue((boolean)((ServiceSupport)log).isStopped(), (String)"Should be stopped");
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda:foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNull((Object)this.context.hasEndpoint("seda://bar"));
        Assertions.assertNull((Object)this.context.hasEndpoint("log://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda://stop"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://stop"));
        this.context.getRouteController().stopRoute("baz");
        this.context.removeRoute("baz");
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNull((Object)this.context.hasEndpoint("seda://bar"));
        Assertions.assertNull((Object)this.context.hasEndpoint("log://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
        Assertions.assertNull((Object)this.context.hasEndpoint("seda://stop"));
        Assertions.assertNull((Object)this.context.hasEndpoint("mock://stop"));
        this.context.stop();
        Assertions.assertFalse((boolean)((ServiceSupport)seda).isStarted(), (String)"Should not be started");
        Assertions.assertFalse((boolean)((ServiceSupport)log).isStarted(), (String)"Should not be started");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("log:foo")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("seda:bar").routeId("bar").to("log:bar")).to("log:bar")).to("mock:result");
                this.from("seda:stop").routeId("baz").to("mock:stop");
            }
        };
    }
}

