/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RegistryLookupTypeClassCastExceptionTest {
    @Test
    public void testLookupOk() {
        DefaultRegistry registry = new DefaultRegistry();
        MyClass my = new MyClass();
        registry.bind("my", (Object)my);
        Assertions.assertEquals((Object)my, (Object)registry.lookupByName("my"));
        Assertions.assertEquals((Object)my, (Object)registry.lookupByNameAndType("my", MyClass.class));
        Assertions.assertNull((Object)registry.lookupByName("foo"));
        Assertions.assertNull((Object)registry.lookupByNameAndType("foo", MyClass.class));
    }

    @Test
    public void testCamelContextLookupOk() {
        DefaultCamelContext context = new DefaultCamelContext();
        MyClass my = new MyClass();
        context.getRegistry().bind("my", (Object)my);
        Assertions.assertEquals((Object)my, (Object)context.getRegistry().lookupByName("my"));
        Assertions.assertEquals((Object)my, (Object)context.getRegistry().lookupByNameAndType("my", MyClass.class));
        Assertions.assertNull((Object)context.getRegistry().lookupByName("foo"));
        Assertions.assertNull((Object)context.getRegistry().lookupByNameAndType("foo", MyClass.class));
    }

    @Test
    public void testCamelContextLookupClassCast() {
        DefaultCamelContext context = new DefaultCamelContext();
        MyClass my = new MyClass();
        context.getRegistry().bind("my", (Object)my);
        Object answer = context.getRegistry().lookupByNameAndType("my", String.class);
        Assertions.assertNull((Object)answer);
        answer = context.getRegistry().lookupByNameAndType("my", MyClass.class);
        Assertions.assertNotNull((Object)answer);
    }

    public static class MyClass {
    }
}

