/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProducerCacheNonSingletonTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testNonSingleton() {
        this.context.addComponent("dummy", (Component)new MyDummyComponent());
        DefaultProducerCache cache = new DefaultProducerCache((Object)this, (CamelContext)this.context, 100);
        cache.start();
        Endpoint endpoint = this.context.getEndpoint("dummy:foo");
        DefaultAsyncProducer producer = (DefaultAsyncProducer)cache.acquireProducer(endpoint);
        Assertions.assertNotNull((Object)producer);
        Assertions.assertTrue((boolean)producer.getStatus().isStarted(), (String)"Should be started");
        Object found = this.context.hasService(MyDummyProducer.class);
        Assertions.assertNull((Object)found, (String)"Should not store producer on CamelContext");
        cache.releaseProducer(endpoint, (AsyncProducer)producer);
        Assertions.assertTrue((boolean)producer.getStatus().isStarted(), (String)"Should still be started");
        cache.stop();
        Assertions.assertTrue((boolean)producer.getStatus().isStopped(), (String)"Should be stopped");
    }

    public static class MyDummyComponent
    extends DefaultComponent {
        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new MyDummyEndpoint();
        }
    }

    private static class MyDummyProducer
    extends DefaultAsyncProducer {
        public MyDummyProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            return false;
        }
    }

    public static class MyDummyEndpoint
    extends DefaultEndpoint {
        public Producer createProducer() {
            return new MyDummyProducer((Endpoint)this);
        }

        public Consumer createConsumer(Processor processor) {
            return null;
        }

        public boolean isSingleton() {
            return false;
        }

        protected String createEndpointUri() {
            return "dummy://foo";
        }
    }
}

