/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Exchange;
import org.apache.camel.Produce;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PojoProduceInterceptEndpointTest {
    @Test
    public void testPojoProduceInterceptAlreadyStarted() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("direct:start").to("language:simple:${body}${body}");
                this.from("direct:start").to("mock:result");
            }
        });
        context.start();
        MyBean bean = (MyBean)context.getInjector().newInstance(MyBean.class);
        MockEndpoint mock = (MockEndpoint)context.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedBodiesReceived(new Object[]{"WorldWorld"});
        Object reply = bean.doSomething("World");
        Assertions.assertEquals((Object)"WorldWorld", (Object)reply);
        mock.assertIsSatisfied();
        context.stop();
    }

    @Test
    public void testPojoProduceInterceptNotStarted() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("direct:start").to("language:simple:${body}${body}");
                this.from("direct:start").to("mock:result");
            }
        });
        MyBean bean = (MyBean)context.getInjector().newInstance(MyBean.class);
        context.start();
        MockEndpoint mock = (MockEndpoint)context.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedBodiesReceived(new Object[]{"WorldWorld"});
        Object reply = bean.doSomething("World");
        Assertions.assertEquals((Object)"WorldWorld", (Object)reply);
        mock.assertIsSatisfied();
        context.stop();
    }

    public static class MyBean {
        @Produce(value="direct:start")
        Producer producer;

        public Object doSomething(String body) throws Exception {
            Exchange exchange = this.producer.getEndpoint().createExchange();
            exchange.getIn().setBody((Object)body);
            this.producer.process(exchange);
            return exchange.getMessage().getBody();
        }
    }
}

