/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PendingExchangesTwoRouteShutdownGracefulTest
extends ContextTestSupport {
    private static String foo = "";
    private static String bar = "";
    private static final CountDownLatch latch = new CountDownLatch(2);

    @Test
    public void testShutdownGraceful() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMinimumMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"A");
        this.template.sendBody("seda:foo", (Object)"B");
        this.template.sendBody("seda:foo", (Object)"C");
        this.template.sendBody("seda:foo", (Object)"D");
        this.template.sendBody("seda:foo", (Object)"E");
        this.template.sendBody("seda:bar", (Object)"A");
        this.template.sendBody("seda:bar", (Object)"B");
        this.template.sendBody("seda:bar", (Object)"C");
        this.template.sendBody("seda:bar", (Object)"D");
        this.template.sendBody("seda:bar", (Object)"E");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        this.context.stop();
        Assertions.assertEquals((Object)"ABCDE", (Object)foo, (String)"Should graceful shutdown");
        Assertions.assertEquals((Object)"ABCDE", (Object)bar, (String)"Should graceful shutdown");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").to("mock:foo")).delay(100L).syncDelayed().process(new Processor(){

                    public void process(Exchange exchange) {
                        foo = foo + (String)exchange.getIn().getBody(String.class);
                        latch.countDown();
                    }
                });
                ((RouteDefinition)this.from("seda:bar").to("mock:bar")).delay(50L).syncDelayed().process(new Processor(){

                    public void process(Exchange exchange) {
                        bar = bar + (String)exchange.getIn().getBody(String.class);
                        latch.countDown();
                    }
                });
            }
        };
    }
}

