/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PendingExchangesAsyncDelayShutdownGracefulTest
extends ContextTestSupport {
    @Test
    public void testShutdownGraceful() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMinimumMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"A");
        this.template.sendBody("seda:foo", (Object)"B");
        this.template.sendBody("seda:foo", (Object)"C");
        this.template.sendBody("seda:foo", (Object)"D");
        this.template.sendBody("seda:foo", (Object)"E");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertEquals((int)5, (int)result.getReceivedCounter(), (String)"Expecting all messages");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").to("mock:foo")).delay(1000L).to("mock:result");
            }
        };
    }
}

