/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultipleConsumersSupportTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testNotMultipleConsumersSupport() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                MyEndpoint my = new MyEndpoint();
                my.setCamelContext((CamelContext)MultipleConsumersSupportTest.this.context);
                my.setEndpointUriIfNotSpecified("my:endpoint");
                this.from((Endpoint)my).to("mock:a");
                this.from("direct:start").to("mock:result");
                this.from((Endpoint)my).to("mock:b");
            }
        });
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.start(), (String)"Should have thrown exception");
        Assertions.assertTrue((boolean)e.getMessage().endsWith("Multiple consumers for the same endpoint is not allowed: my:endpoint"));
    }

    @Test
    public void testYesMultipleConsumersSupport() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                MyOtherEndpoint my = new MyOtherEndpoint();
                my.setCamelContext((CamelContext)MultipleConsumersSupportTest.this.context);
                this.from((Endpoint)my).to("mock:a");
                this.from((Endpoint)my).to("mock:b");
            }
        });
        this.context.start();
        this.context.stop();
    }

    private static class MyOtherEndpoint
    extends DefaultEndpoint
    implements MultipleConsumersSupport {
        private MyOtherEndpoint() {
        }

        public boolean isSingleton() {
            return true;
        }

        public boolean isMultipleConsumersSupported() {
            return true;
        }

        public Producer createProducer() {
            return null;
        }

        public Consumer createConsumer(Processor processor) {
            return new DefaultConsumer((Endpoint)this, processor);
        }

        protected String createEndpointUri() {
            return "MyOtherEndpoint";
        }
    }

    private static class MyEndpoint
    extends DefaultEndpoint
    implements MultipleConsumersSupport {
        private MyEndpoint() {
        }

        public boolean isSingleton() {
            return true;
        }

        public boolean isMultipleConsumersSupported() {
            return false;
        }

        public Producer createProducer() {
            return null;
        }

        public Consumer createConsumer(Processor processor) {
            return new DefaultConsumer((Endpoint)this, processor);
        }

        protected String createEndpointUri() {
            return "MyEndpoint";
        }
    }
}

