/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class MultipleComponentInstancesTest
extends ContextTestSupport {
    @Test
    public void testMultipleInstances() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock2:aaa").expectedMessageCount(1);
        this.getMockEndpoint("mock3:bbb").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:bye", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addComponent("log2", context.getComponent("log"));
        context.addComponent("mock2", context.getComponent("mock"));
        context.addComponent("mock3", context.getComponent("mock"));
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("log:bar")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:bye").to("log2:bye")).to("mock2:aaa")).to("mock3:bbb");
            }
        };
    }
}

