/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.SimpleUuidGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MessageSupportTest
extends ContextTestSupport {
    @Test
    public void testSetBodyType() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Message in = exchange.getIn();
        in.setBody((Object)"123", Integer.class);
        MessageSupportTest.assertIsInstanceOf(Integer.class, in.getBody());
    }

    @Test
    public void testGetMandatoryBody() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Message in = exchange.getIn();
        Assertions.assertThrows(InvalidPayloadException.class, () -> ((Message)in).getMandatoryBody(), (String)"Should have thrown an exception");
        in.setBody((Object)"Hello World");
        Assertions.assertEquals((Object)"Hello World", (Object)in.getMandatoryBody());
    }

    @Test
    public void testGetMessageIdWithGenerator() {
        this.context.setUuidGenerator((UuidGenerator)new SimpleUuidGenerator());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Message in = exchange.getIn();
        Assertions.assertEquals((Object)"1", (Object)in.getMessageId());
        Assertions.assertEquals((Object)"1", (Object)in.getExchange().getExchangeId());
    }

    @Test
    public void testGetMessageId() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Message in = exchange.getIn();
        Assertions.assertSame((Object)in.getExchange().getExchangeId(), (Object)in.getMessageId());
    }

    @Test
    public void testGetMessageIdWithoutAnExchange() {
        DefaultMessage in = new DefaultMessage((CamelContext)this.context);
        Assertions.assertNull((Object)in.getMessageId());
    }

    @Test
    public void testCopyFromSameHeadersInstance() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Message in = exchange.getIn();
        Map headers = in.getHeaders();
        headers.put("foo", 123);
        DefaultMessage out = new DefaultMessage((CamelContext)this.context);
        out.setBody((Object)"Bye World");
        out.setHeaders(headers);
        out.copyFrom(in);
        Assertions.assertEquals((Object)123, headers.get("foo"));
        Assertions.assertEquals((Object)123, (Object)in.getHeader("foo"));
        Assertions.assertEquals((Object)123, (Object)out.getHeader("foo"));
    }

    @Test
    public void testCopyOverExchange() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Message in = exchange.getIn();
        in.setBody((Object)"Bye World");
        Message two = in.copy();
        Assertions.assertSame((Object)exchange, (Object)two.getExchange());
        DefaultMessage three = new DefaultMessage((CamelContext)this.context);
        three.copyFrom(two);
        Assertions.assertSame((Object)exchange, (Object)three.getExchange());
    }

    @Test
    public void testNoMessageTimestamp() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Assertions.assertEquals((long)0L, (long)exchange.getMessage().getMessageTimestamp());
    }

    @Test
    public void testMessageTimestamp() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getMessage().setHeader("CamelMessageTimestamp", (Object)1234L);
        Assertions.assertEquals((long)1234L, (long)exchange.getMessage().getMessageTimestamp());
    }
}

