/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.TraceExchangeFormatter;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.xml.StringSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogDebugBodyStreamsTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setStreamCaching(Boolean.valueOf(false));
        return context;
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("logFormatter", (Object)new TraceExchangeFormatter());
        return registry;
    }

    @Test
    public void testLogBodyStreamStringSourceDisabled() throws Exception {
        this.context.getGlobalOptions().put("CamelLogDebugStreams", "false");
        StringSource body = new StringSource("<?xml version=\"1.0\"?><person><name>Claus</name></person>");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        Assertions.assertTrue((boolean)msg.endsWith("Body: <?xml version=\"1.0\"?><person><name>Claus</name></person>]"));
    }

    @Test
    public void testLogBodyStreamStringSourceDisabledByDefault() throws Exception {
        this.context.getGlobalOptions().remove("CamelLogDebugStreams");
        StringSource body = new StringSource("<?xml version=\"1.0\"?><person><name>Claus</name></person>");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        Assertions.assertTrue((boolean)msg.endsWith("Body: <?xml version=\"1.0\"?><person><name>Claus</name></person>]"));
    }

    @Test
    public void testLogBodyStreamStringSourceEnabled() throws Exception {
        this.context.getGlobalOptions().put("CamelLogDebugStreams", "true");
        StringSource body = new StringSource("<?xml version=\"1.0\"?><person><name>Claus</name></person>");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        Assertions.assertTrue((boolean)msg.endsWith("Body: <?xml version=\"1.0\"?><person><name>Claus</name></person>]"));
    }

    @Test
    public void testLogBodyStreamDisabled() throws Exception {
        this.context.getGlobalOptions().put("CamelLogDebugStreams", "false");
        ByteArrayInputStream body = new ByteArrayInputStream("Hello World".getBytes());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        Assertions.assertTrue((boolean)msg.endsWith("Body: [Body is instance of java.io.InputStream]]"));
    }

    @Test
    public void testLogBodyStreamDisabledByDefault() throws Exception {
        this.context.getGlobalOptions().remove("CamelLogDebugStreams");
        ByteArrayInputStream body = new ByteArrayInputStream("Hello World".getBytes());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        Assertions.assertTrue((boolean)msg.endsWith("Body: [Body is instance of java.io.InputStream]]"));
    }

    @Test
    public void testLogBodyStreamEnabled() throws Exception {
        this.context.getGlobalOptions().put("CamelLogDebugStreams", "true");
        ByteArrayInputStream body = new ByteArrayInputStream("Hello World".getBytes());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        Assertions.assertTrue((boolean)msg.endsWith("Body: [Body is instance of java.io.InputStream]]"));
        LogDebugBodyStreamsTest.assertIsInstanceOf(InputStream.class, ((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

