/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.TraceExchangeFormatter;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LogDebugBodyMaxCharsOffTest
extends ContextTestSupport {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.context.getGlobalOptions().put("CamelLogDebugBodyMaxChars", "-1");
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("logFormatter", (Object)new TraceExchangeFormatter());
        return registry;
    }

    @Test
    public void testLogBodyMaxLengthTest() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            int value = i % 10;
            sb.append(value);
        }
        String body = sb.toString();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        Assertions.assertTrue((boolean)msg.endsWith("Body: [Body is not logged]]"));
        Assertions.assertNotSame((Object)msg, (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(String.class), (String)"clipped log and real body should not be the same");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

