/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.MockScheduledPollConsumer;
import org.apache.camel.impl.engine.LimitedPollingConsumerPollStrategy;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.service.ServiceHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class LimitedPollingConsumerPollStrategyTest
extends ContextTestSupport {
    private LimitedPollingConsumerPollStrategy strategy;

    @Test
    public void testLimitedPollingConsumerPollStrategy() {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(3);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should be started");
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.run();
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isSuspended(), (String)"Should be suspended");
        consumer.stop();
    }

    @Test
    public void testLimitAtTwoLimitedPollingConsumerPollStrategy() {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(2);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.run();
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isSuspended(), (String)"Should be suspended");
        consumer.stop();
    }

    @Test
    public void testLimitedPollingConsumerPollStrategySuccess() {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(3);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should be started");
        consumer.run();
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.setExceptionToThrowOnPoll(null);
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.stop();
    }

    @Test
    public void testLimitedPollingConsumerPollStrategySuccessThenFail() {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(3);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.setExceptionToThrowOnPoll(null);
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.setExceptionToThrowOnPoll(expectedException);
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.run();
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isSuspended(), (String)"Should be suspended");
        consumer.stop();
    }

    @Test
    public void testTwoConsumersLimitedPollingConsumerPollStrategy() {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(3);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        MockScheduledPollConsumer consumer2 = new MockScheduledPollConsumer((Endpoint)endpoint, null);
        consumer2.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        consumer2.start();
        consumer.run();
        consumer2.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        Assertions.assertTrue((boolean)consumer2.isStarted(), (String)"Should still be started");
        consumer.run();
        consumer2.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        Assertions.assertTrue((boolean)consumer2.isStarted(), (String)"Should still be started");
        consumer.run();
        consumer2.run();
        Assertions.assertTrue((boolean)consumer.isSuspended(), (String)"Should be suspended");
        Assertions.assertTrue((boolean)consumer2.isStarted(), (String)"Should still be started");
        consumer.stop();
        consumer2.stop();
    }

    @Test
    public void testRestartManuallyLimitedPollingConsumerPollStrategy() {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(3);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.run();
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isSuspended(), (String)"Should be suspended");
        ServiceHelper.resumeService((Object)((Object)consumer));
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.run();
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isSuspended(), (String)"Should be suspended");
        ServiceHelper.resumeService((Object)((Object)consumer));
        consumer.setExceptionToThrowOnPoll(null);
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.run();
        Assertions.assertTrue((boolean)consumer.isStarted(), (String)"Should still be started");
        consumer.stop();
    }
}

