/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DummyLifecycleStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LifecycleStrategyServiceTest
extends TestSupport {
    private final MyLifecycleStrategy dummy1 = new MyLifecycleStrategy();

    protected CamelContext createCamelContext() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addLifecycleStrategy((LifecycleStrategy)this.dummy1);
        return context;
    }

    @Test
    public void testLifecycleStrategyService() throws Exception {
        Assertions.assertFalse((boolean)this.dummy1.isStarted());
        CamelContext context = this.createCamelContext();
        context.start();
        Assertions.assertTrue((boolean)this.dummy1.isStarted());
        context.stop();
        Assertions.assertFalse((boolean)this.dummy1.isStarted());
    }

    private static class MyLifecycleStrategy
    extends DummyLifecycleStrategy
    implements Service {
        private volatile boolean started;

        private MyLifecycleStrategy() {
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.started = false;
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

