/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.OnCamelContextInitialized;
import org.apache.camel.spi.OnCamelContextInitializing;
import org.apache.camel.spi.OnCamelContextStarting;
import org.apache.camel.spi.OnCamelContextStopping;
import org.apache.camel.support.LifecycleStrategySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LifecycleStrategyDiscoveryTest
extends TestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLifecycleStrategyDiscovery() throws Exception {
        AtomicInteger onInitializing = new AtomicInteger();
        AtomicInteger onInitialized = new AtomicInteger();
        AtomicInteger onStarting = new AtomicInteger();
        AtomicInteger onStarted = new AtomicInteger();
        AtomicInteger onStopping = new AtomicInteger();
        AtomicInteger onStopped = new AtomicInteger();
        final AtomicInteger onInitializingRoute = new AtomicInteger();
        final AtomicInteger onInitializedRoute = new AtomicInteger();
        final AtomicInteger onStartRoute = new AtomicInteger();
        final AtomicInteger onStopRoute = new AtomicInteger();
        DefaultCamelContext context = new DefaultCamelContext();
        context.getRegistry().bind("myOnInitializing", (Object)LifecycleStrategySupport.onCamelContextInitializing(c -> onInitializing.incrementAndGet()));
        context.getRegistry().bind("myOnInitialized", (Object)LifecycleStrategySupport.onCamelContextInitialized(c -> onInitialized.incrementAndGet()));
        context.getRegistry().bind("myOnStarting", (Object)LifecycleStrategySupport.onCamelContextStarting(c -> onStarting.incrementAndGet()));
        context.getRegistry().bind("myOnStarted", (Object)LifecycleStrategySupport.onCamelContextStarted(c -> onStarted.incrementAndGet()));
        context.getRegistry().bind("myOnStopping", (Object)LifecycleStrategySupport.onCamelContextStopping(c -> onStopping.incrementAndGet()));
        context.getRegistry().bind("myOnStopped", (Object)LifecycleStrategySupport.onCamelContextStopped(c -> onStopped.incrementAndGet()));
        try {
            class MyBuilder
            extends RouteBuilder
            implements OnCamelContextInitializing,
            OnCamelContextInitialized,
            OnCamelContextStarting,
            OnCamelContextStopping {
                MyBuilder() {
                }

                public void configure() {
                }

                public void onContextInitializing(CamelContext context) {
                    onInitializingRoute.incrementAndGet();
                }

                public void onContextInitialized(CamelContext context) {
                    onInitializedRoute.incrementAndGet();
                }

                public void onContextStarting(CamelContext context) {
                    onStartRoute.incrementAndGet();
                }

                public void onContextStopping(CamelContext context) {
                    onStopRoute.incrementAndGet();
                }
            }
            context.addRoutes((RoutesBuilder)new MyBuilder());
            context.start();
        }
        finally {
            context.stop();
        }
        Assertions.assertEquals((int)1, (int)onInitializing.get());
        Assertions.assertEquals((int)1, (int)onInitialized.get());
        Assertions.assertEquals((int)1, (int)onStarting.get());
        Assertions.assertEquals((int)1, (int)onStarted.get());
        Assertions.assertEquals((int)1, (int)onStopping.get());
        Assertions.assertEquals((int)1, (int)onStopped.get());
        Assertions.assertEquals((int)1, (int)onInitializingRoute.get());
        Assertions.assertEquals((int)1, (int)onInitializedRoute.get());
        Assertions.assertEquals((int)1, (int)onStartRoute.get());
        Assertions.assertEquals((int)1, (int)onStopRoute.get());
    }
}

