/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.StatefulService;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.support.LazyStartProducer;
import org.apache.camel.support.service.ServiceHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LazyStartProducerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testLazyStartProducer() throws Exception {
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello Lazy Producer", "Hello Again Lazy Producer"});
        LazyStartProducer lazy = new LazyStartProducer((Endpoint)mock);
        Assertions.assertFalse((boolean)ServiceHelper.isStarted((StatefulService)lazy));
        Assertions.assertFalse((boolean)ServiceHelper.isStarted((Object)lazy.getProcessor()));
        Assertions.assertEquals((Object)mock.isSingleton(), (Object)lazy.isSingleton());
        ServiceHelper.startService((Service)lazy);
        Assertions.assertTrue((boolean)ServiceHelper.isStarted((StatefulService)lazy));
        Assertions.assertFalse((boolean)ServiceHelper.isStarted((Object)lazy.getProcessor()));
        Assertions.assertEquals((Object)mock.isSingleton(), (Object)lazy.isSingleton());
        Exchange exchange = mock.createExchange();
        exchange.getIn().setBody((Object)"Hello Lazy Producer");
        lazy.process(exchange);
        Assertions.assertTrue((boolean)ServiceHelper.isStarted((StatefulService)lazy));
        Assertions.assertTrue((boolean)ServiceHelper.isStarted((Object)lazy.getProcessor()));
        Assertions.assertEquals((Object)mock.isSingleton(), (Object)lazy.isSingleton());
        exchange = mock.createExchange();
        exchange.getIn().setBody((Object)"Hello Again Lazy Producer");
        lazy.process(exchange);
        Assertions.assertTrue((boolean)ServiceHelper.isStarted((StatefulService)lazy));
        Assertions.assertTrue((boolean)ServiceHelper.isStarted((Object)lazy.getProcessor()));
        Assertions.assertEquals((Object)mock.isSingleton(), (Object)lazy.isSingleton());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void lazyStartProducerGlobal() {
        this.context.getGlobalEndpointConfiguration().setLazyStartProducer(true);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        Assertions.assertTrue((boolean)mock.isLazyStartProducer());
        LogEndpoint log = this.getMandatoryEndpoint("log:foo", LogEndpoint.class);
        Assertions.assertTrue((boolean)log.isLazyStartProducer());
    }

    @Test
    public void lazyStartProducerComponent() {
        ((LogComponent)this.context.getComponent("log", LogComponent.class)).setLazyStartProducer(true);
        LogEndpoint log = this.getMandatoryEndpoint("log:foo", LogEndpoint.class);
        Assertions.assertTrue((boolean)log.isLazyStartProducer());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        Assertions.assertFalse((boolean)mock.isLazyStartProducer());
        MockEndpoint mock2 = this.getMockEndpoint("mock:foo?lazyStartProducer=true");
        Assertions.assertTrue((boolean)mock2.isLazyStartProducer());
    }
}

