/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.junit.jupiter.api.Test;

class LanguageFluentSyntaxTest
extends ContextTestSupport {
    LanguageFluentSyntaxTest() {
    }

    @Test
    void testAsSplitExpression() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"A", "B"});
        this.template.sendBody("direct:a", (Object)"A\nB");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testAsOuterExpression() throws Exception {
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World Out"});
        this.template.sendBody("direct:b", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testAsInnerExpression() throws Exception {
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Hello World In"});
        this.template.sendBody("direct:c", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testAsFiler() throws Exception {
        this.getMockEndpoint("mock:d").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("direct:d", (Object)"Hello World", "foo", (Object)"bar");
        this.template.sendBodyAndHeader("direct:d", (Object)"Bye World", "foo", (Object)"other");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").split((Expression)this.expression().tokenize().token("\n").end()).to("mock:a");
                ((ProcessorDefinition)this.from("direct:b").setBody().expression((Expression)((SimpleExpression.Builder)this.expression().simple().expression("Hello World Out")).end())).to("mock:b");
                ((RouteDefinition)this.from("direct:c").setBody((Expression)((SimpleExpression.Builder)this.expression().simple().expression("Hello World In")).end())).to("mock:c");
                this.from("direct:d").filter(this.expression((Expression)((HeaderExpression.Builder)this.expression().header().expression("foo")).end()).isEqualTo((Object)"bar")).to("mock:d");
            }
        };
    }
}

