/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanguageCamelContextAwareTest
extends ContextTestSupport {
    private final MyLanguage my = new MyLanguage();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("my", (Object)this.my);
        return registry;
    }

    @Test
    public void testLanguageCamelContextAware() {
        Language lan = this.context.resolveLanguage("my");
        Assertions.assertNotNull((Object)lan);
        MyLanguage me = LanguageCamelContextAwareTest.assertIsInstanceOf(MyLanguage.class, lan);
        Assertions.assertNotNull((Object)me.getCamelContext());
    }

    private static class MyLanguage
    implements Language,
    CamelContextAware {
        private CamelContext camelContext;

        private MyLanguage() {
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public Predicate createPredicate(String expression) {
            return null;
        }

        public Expression createExpression(String expression) {
            return null;
        }
    }
}

