/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DefaultInflightRepository;
import org.apache.camel.spi.InflightRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InflightRepositoryRouteTest
extends ContextTestSupport {
    @Test
    public void testInflight() {
        this.context.setInflightRepository((InflightRepository)new MyInflightRepo());
        Assertions.assertEquals((int)0, (int)this.context.getInflightRepository().size());
        this.template.sendBody("direct:start", (Object)"Hello World");
        Assertions.assertEquals((int)0, (int)this.context.getInflightRepository().size());
        Assertions.assertEquals((int)0, (int)this.context.getInflightRepository().size("foo"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        };
    }

    private class MyInflightRepo
    extends DefaultInflightRepository {
        private MyInflightRepo() {
        }

        public void add(Exchange exchange) {
            super.add(exchange);
            Assertions.assertEquals((int)1, (int)InflightRepositoryRouteTest.this.context.getInflightRepository().size());
        }

        public void add(Exchange exchange, String routeId) {
            super.add(exchange, routeId);
            Assertions.assertEquals((int)1, (int)InflightRepositoryRouteTest.this.context.getInflightRepository().size("foo"));
        }
    }
}

