/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.InflightRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InflightRepositoryBrowseFromRouteTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getInflightRepository().setInflightBrowseEnabled(true);
        return context;
    }

    @Test
    public void testInflight() {
        Assertions.assertEquals((int)0, (int)this.context.getInflightRepository().browse().size());
        this.template.sendBody("direct:start", (Object)"Hello World");
        Assertions.assertEquals((int)0, (int)this.context.getInflightRepository().browse().size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("mock:a")).to("direct:bar")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:bar").routeId("bar").to("mock:b")).process(new Processor(){

                    public void process(Exchange exchange) {
                        Collection list = InflightRepositoryBrowseFromRouteTest.this.context.getInflightRepository().browse("foo");
                        Assertions.assertEquals((int)1, (int)list.size());
                        InflightRepository.InflightExchange inflight = (InflightRepository.InflightExchange)list.iterator().next();
                        Assertions.assertNotNull((Object)inflight);
                        Assertions.assertEquals((Object)exchange, (Object)inflight.getExchange());
                        Assertions.assertEquals((Object)"foo", (Object)inflight.getFromRouteId());
                        Assertions.assertEquals((Object)"bar", (Object)inflight.getAtRouteId());
                        Assertions.assertEquals((Object)"myProcessor", (Object)inflight.getNodeId());
                    }
                })).id("myProcessor");
            }
        };
    }
}

