/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultHeaderFilterStrategy;
import org.apache.camel.support.HeaderFilterStrategyComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HeaderFilterStrategyComponentTest {
    @Test
    public void testHeaderFilterStrategyComponent() {
        MyComponent comp = new MyComponent(MyEndpoint.class);
        Assertions.assertNull((Object)comp.getHeaderFilterStrategy());
        DefaultHeaderFilterStrategy strategy = new DefaultHeaderFilterStrategy();
        comp.setHeaderFilterStrategy((HeaderFilterStrategy)strategy);
        Assertions.assertSame((Object)strategy, (Object)comp.getHeaderFilterStrategy());
    }

    @Test
    public void testHeaderFilterStrategyAware() {
        MyComponent comp = new MyComponent(MyEndpoint.class);
        Assertions.assertNull((Object)comp.getHeaderFilterStrategy());
        DefaultHeaderFilterStrategy strategy = new DefaultHeaderFilterStrategy();
        comp.setHeaderFilterStrategy((HeaderFilterStrategy)strategy);
        MyEndpoint my = new MyEndpoint();
        comp.setEndpointHeaderFilterStrategy((Endpoint)my);
        Assertions.assertSame((Object)strategy, (Object)my.getHeaderFilterStrategy());
        Assertions.assertSame((Object)strategy, (Object)comp.getHeaderFilterStrategy());
    }

    private static class MyComponent
    extends HeaderFilterStrategyComponent {
        MyComponent(Class<? extends Endpoint> endpointClass) {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return null;
        }
    }

    private static class MyEndpoint
    extends DefaultEndpoint
    implements HeaderFilterStrategyAware {
        private HeaderFilterStrategy strategy;

        private MyEndpoint() {
        }

        public HeaderFilterStrategy getHeaderFilterStrategy() {
            return this.strategy;
        }

        public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
            this.strategy = strategy;
        }

        public Producer createProducer() {
            return null;
        }

        public Consumer createConsumer(Processor processor) {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

