/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.HashMapHeadersMapFactory;
import org.apache.camel.spi.HeadersMapFactory;
import org.junit.jupiter.api.Test;

public class HashMapHeadersMapFactoryRouteTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getCamelContextExtension().setHeadersMapFactory((HeadersMapFactory)new HashMapHeadersMapFactory());
        return context;
    }

    @Test
    public void testHashMapHeaders() throws Exception {
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)123);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("FOO", (Object)456);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("Bar", (Object)"yes");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("foo", 123);
        headers.put("FOO", 456);
        headers.put("Bar", "yes");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

