/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GracefulShutdownNoAutoStartOrderClashTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testStartupOrderClash() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:foo").routeId("foo").startupOrder(5).to("mock:foo");
                this.from("direct:bar").routeId("bar").startupOrder(5).autoStartup(false).to("mock:bar");
            }
        });
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.start(), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"Failed to start route bar because of startupOrder clash. Route foo already has startupOrder 5 configured which this route have as well. Please correct startupOrder to be unique among all your routes.", (Object)e.getMessage());
    }
}

