/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromMultipleEndpointTest
extends ContextTestSupport {
    @Test
    public void testMultipleFromEndpoint() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:results");
        mock.expectedMessageCount(2);
        this.template.sendBody("direct:foo", (Object)"foo");
        this.template.sendBody("seda:bar", (Object)"bar");
        mock.assertIsSatisfied();
        List list = mock.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        Endpoint fromEndpoint = exchange.getFromEndpoint();
        Assertions.assertEquals((Object)"direct://foo", (Object)fromEndpoint.getEndpointUri(), (String)"fromEndpoint URI");
        exchange = (Exchange)list.get(1);
        fromEndpoint = exchange.getFromEndpoint();
        Assertions.assertEquals((Object)"seda://bar", (Object)fromEndpoint.getEndpointUri(), (String)"fromEndpoint URI");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.getContext().setTracing(Boolean.valueOf(true));
                this.from("direct:foo").to("mock:results");
                this.from("seda:bar").to("mock:results");
            }
        };
    }
}

