/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromEndpointTest
extends ContextTestSupport {
    private final Object expectedBody = "<hello>world!</hello>";

    @Test
    public void testReceivedMessageHasFromEndpointSet() throws Exception {
        MockEndpoint results = this.getMockEndpoint("mock:results");
        results.expectedBodiesReceived(new Object[]{this.expectedBody});
        this.template.sendBody("direct:start", this.expectedBody);
        results.assertIsSatisfied();
        List list = results.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        Endpoint fromEndpoint = exchange.getFromEndpoint();
        Assertions.assertNotNull((Object)fromEndpoint, (String)"exchange.fromEndpoint() is null!");
        Assertions.assertEquals((Object)"direct://start", (Object)fromEndpoint.getEndpointUri(), (String)"fromEndpoint URI");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:results");
            }
        };
    }
}

