/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExtendedStartupListener;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExtendedStartupListenerComponentTest
extends ContextTestSupport {
    private MyComponent my;

    @Test
    public void testExtendedStartupListenerComponent() throws Exception {
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("bar").isStarted());
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("late").isStarted());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:late").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.template.sendBody("direct:late", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)this.my.getInvoked());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ExtendedStartupListenerComponentTest.this.my = new MyComponent();
                ExtendedStartupListenerComponentTest.this.context.addComponent("my", (Component)ExtendedStartupListenerComponentTest.this.my);
                this.from("direct:foo").routeId("foo").to("my:bar");
                this.from("my:bar").routeId("bar").to("mock:result");
            }
        };
    }

    private static class MyComponent
    extends DirectComponent
    implements ExtendedStartupListener {
        private int invoked;

        private MyComponent() {
        }

        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) {
            ++this.invoked;
            if (!alreadyStarted) {
                Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("foo").isStopped());
                Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("bar").isStopped());
            }
        }

        public int getInvoked() {
            return this.invoked;
        }

        public void onCamelContextFullyStarted(CamelContext context, boolean alreadyStarted) throws Exception {
            ++this.invoked;
            Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("foo").isStarted());
            Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("bar").isStarted());
            context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.from("direct:late").routeId("late").to("mock:late");
                }
            });
        }
    }
}

