/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.EventDrivenPollingConsumer;
import org.apache.camel.support.service.ServiceHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EventDrivenPollingConsumerQueueSizeTest
extends ContextTestSupport {
    private final String uri = "my:foo?pollingConsumerQueueSize=10&pollingConsumerBlockWhenFull=false";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.context.addComponent("my", (Component)new MyQueueComponent());
    }

    @Test
    public void testQueueSize() throws Exception {
        this.context.start();
        PollingConsumer consumer = this.context.getEndpoint("my:foo?pollingConsumerQueueSize=10&pollingConsumerBlockWhenFull=false").createPollingConsumer();
        consumer.start();
        Assertions.assertNotNull((Object)consumer);
        EventDrivenPollingConsumer edpc = EventDrivenPollingConsumerQueueSizeTest.assertIsInstanceOf(EventDrivenPollingConsumer.class, consumer);
        Assertions.assertEquals((int)0, (int)edpc.getQueueSize());
        Assertions.assertEquals((int)10, (int)edpc.getQueueCapacity());
        Assertions.assertFalse((boolean)edpc.isBlockWhenFull());
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("my:foo?pollingConsumerQueueSize=10&pollingConsumerBlockWhenFull=false", (Object)("Message " + i));
        }
        Assertions.assertEquals((int)10, (int)edpc.getQueueSize());
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("my:foo?pollingConsumerQueueSize=10&pollingConsumerBlockWhenFull=false", (Object)"Message 10"), (String)"Should have thrown exception");
        EventDrivenPollingConsumerQueueSizeTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
        Exchange out = consumer.receive(5000L);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"Message 0", (Object)out.getIn().getBody());
        Assertions.assertEquals((int)9, (int)edpc.getQueueSize());
        Assertions.assertEquals((int)10, (int)edpc.getQueueCapacity());
        this.template.sendBody("my:foo?pollingConsumerQueueSize=10&pollingConsumerBlockWhenFull=false", (Object)"Message 10");
        Assertions.assertEquals((int)10, (int)edpc.getQueueSize());
        Assertions.assertEquals((int)10, (int)edpc.getQueueCapacity());
        ServiceHelper.stopService((Service)consumer);
        Assertions.assertEquals((int)10, (int)edpc.getQueueSize());
        Assertions.assertEquals((int)10, (int)edpc.getQueueCapacity());
        ServiceHelper.stopAndShutdownService((Object)consumer);
        Assertions.assertEquals((int)0, (int)edpc.getQueueSize());
        Assertions.assertEquals((int)10, (int)edpc.getQueueCapacity());
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private static final class MyQueueComponent
    extends DefaultComponent {
        private MyQueueComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new MyQueueEndpoint(uri, (Component)this);
        }
    }

    private static final class MyQueueEndpoint
    extends DefaultEndpoint {
        private EventDrivenPollingConsumer consumer;

        private MyQueueEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public Producer createProducer() {
            return new DefaultProducer((Endpoint)this){

                public void process(Exchange exchange) throws Exception {
                    consumer.process(exchange);
                }
            };
        }

        public Consumer createConsumer(Processor processor) {
            return this.consumer;
        }

        public PollingConsumer createPollingConsumer() {
            return this.consumer;
        }

        public boolean isSingleton() {
            return true;
        }

        protected void doStart() throws Exception {
            this.consumer = (EventDrivenPollingConsumer)super.createPollingConsumer();
            super.doStart();
        }
    }
}

