/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventDrivenPollingConsumerCopyTest
extends ContextTestSupport {
    private final AtomicBoolean done = new AtomicBoolean();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testCopy() throws Exception {
        PollingConsumer pc = this.context.getEndpoint("direct:foo?pollingConsumerCopy=true").createPollingConsumer();
        pc.start();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getUnitOfWork().addSynchronization((Synchronization)new SynchronizationAdapter(){

                            public void onDone(Exchange exchange) {
                                EventDrivenPollingConsumerCopyTest.this.done.set(true);
                            }
                        });
                    }
                })).to("direct:foo")).to("mock:result");
            }
        });
        this.context.start();
        Assertions.assertEquals((int)0, (int)this.context.getInflightRepository().size());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Exchange original = (Exchange)this.getMockEndpoint("mock:result").getExchanges().get(0);
        Assertions.assertNotNull((Object)original);
        Assertions.assertFalse((boolean)this.done.get(), (String)"UoW should be handed over");
        Exchange polled = pc.receive(1000L);
        Assertions.assertNotNull((Object)polled);
        Assertions.assertEquals((Object)"Hello World", (Object)polled.getMessage().getBody());
        Assertions.assertNotEquals((Object)polled.getExchangeId(), (Object)original.getExchangeId());
        Assertions.assertEquals((int)1, (int)this.context.getInflightRepository().size());
        polled.getUnitOfWork().done(polled);
        Assertions.assertTrue((boolean)this.done.get(), (String)"UoW should be done now");
        Assertions.assertEquals((int)0, (int)this.context.getInflightRepository().size());
        pc.stop();
        this.context.stop();
    }
}

