/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndpointShutdownOnceTest {
    @Test
    public void testEndpointShutdown() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addComponent("my", (Component)new MyComponent());
        context.start();
        MyEndpoint my = (MyEndpoint)context.getEndpoint("my:foo", MyEndpoint.class);
        Assertions.assertTrue((boolean)my.getStatus().isStarted(), (String)"Should be started");
        context.stop();
        Assertions.assertFalse((boolean)my.getStatus().isStarted(), (String)"Should not be started");
        Assertions.assertTrue((boolean)my.getStatus().isStopped(), (String)"Should be stopped");
        Assertions.assertEquals((int)1, (int)my.getInvoked(), (String)"Should only shutdown once");
    }

    private static final class MyComponent
    extends DefaultComponent {
        private MyComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new MyEndpoint(uri, (Component)this);
        }
    }

    private static final class MyEndpoint
    extends DefaultEndpoint {
        private final LongAdder invoked = new LongAdder();

        private MyEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public int getInvoked() {
            return this.invoked.intValue();
        }

        public Producer createProducer() {
            return null;
        }

        public Consumer createConsumer(Processor processor) {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }

        protected void doShutdown() throws Exception {
            super.doShutdown();
            this.invoked.increment();
        }
    }
}

