/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndpointRegistryKeepRouteEndpointsTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getGlobalOptions().put("CamelMaximumEndpointCacheSize", "20");
        return context;
    }

    @Test
    public void testEndpointRegistryKeepRouteEndpoints() {
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct://start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
        Assertions.assertNull((Object)this.context.hasEndpoint("mock://unknown0"));
        for (int i = 0; i < 50; ++i) {
            this.template.sendBody("mock:unknown" + i, (Object)("Hello " + i));
        }
        this.context.getEndpointRegistry().cleanUp();
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct://start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
        int count = 0;
        for (int i = 0; i < 50; ++i) {
            String uri = "mock://unknown" + i;
            if (this.context.hasEndpoint(uri) == null) continue;
            ++count;
            Assertions.assertTrue((boolean)this.context.getEndpointRegistry().isDynamic(uri));
        }
        Assertions.assertEquals((int)20, (int)count, (String)"Should only be 20 dynamic endpoints in the cache");
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().staticSize());
        Assertions.assertTrue((boolean)this.context.getEndpointRegistry().isStatic("direct://start"));
        Assertions.assertEquals((int)20, (int)this.context.getEndpointRegistry().dynamicSize());
        Assertions.assertEquals((int)24, (int)this.context.getEndpointRegistry().size());
        Assertions.assertEquals((int)24, (int)this.context.getEndpoints().size());
        this.context.getEndpointRegistry().purge();
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().staticSize());
        Assertions.assertEquals((int)0, (int)this.context.getEndpointRegistry().dynamicSize());
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct://start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("log:bar")).to("mock:result");
            }
        };
    }
}

