/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndpointRegistryKeepRouteEndpointsRemoteRouteTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getGlobalOptions().put("CamelMaximumEndpointCacheSize", "20");
        return context;
    }

    @Test
    public void testEndpointRegistryKeepRouteEndpointsRemoveRoute() throws Exception {
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct://start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://bar"));
        Assertions.assertEquals((int)6, (int)this.context.getEndpointRegistry().staticSize());
        Assertions.assertNull((Object)this.context.hasEndpoint("mock://unknown0"));
        for (int i = 0; i < 50; ++i) {
            this.template.sendBody("mock:unknown" + i, (Object)("Hello " + i));
        }
        Assertions.assertEquals((int)6, (int)this.context.getEndpointRegistry().staticSize());
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct://start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct://bar"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://bar"));
        this.context.getRouteController().stopRoute("bar");
        this.context.removeRoute("bar");
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().staticSize());
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct://start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log://foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock://result"));
        Assertions.assertNull((Object)this.context.hasEndpoint("direct://bar"));
        Assertions.assertNull((Object)this.context.hasEndpoint("log://bar"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:start")).to("log:foo")).to("mock:result");
                this.from("direct:bar").routeId("bar").to("log:bar");
            }
        };
    }
}

