/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.LifecycleStrategySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndpointPrototypeTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testGetPrototype() {
        this.context.start();
        Assertions.assertEquals((int)0, (int)this.context.getEndpointRegistry().size());
        this.context.getEndpoint("mock:foo");
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        Endpoint prototype = this.context.getCamelContextExtension().getPrototypeEndpoint("mock:bar");
        Assertions.assertNotNull((Object)prototype);
        MockEndpoint bar = EndpointPrototypeTest.assertIsInstanceOf(MockEndpoint.class, prototype);
        Assertions.assertTrue((boolean)bar.getStatus().isStarted());
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.context.getEndpoint("mock:foo2");
        Assertions.assertEquals((int)2, (int)this.context.getEndpointRegistry().size());
        this.context.stop();
        Assertions.assertFalse((boolean)bar.getStatus().isStopped());
        bar.stop();
        Assertions.assertTrue((boolean)bar.getStatus().isStopped());
    }

    @Test
    public void testGetPrototypeNoLifecycleStrategy() {
        final ArrayList endpoints = new ArrayList();
        LifecycleStrategySupport dummy = new LifecycleStrategySupport(){

            public void onEndpointAdd(Endpoint endpoint) {
                endpoints.add(endpoint);
            }
        };
        this.context.addLifecycleStrategy((LifecycleStrategy)dummy);
        this.context.start();
        Assertions.assertEquals((int)0, (int)this.context.getEndpointRegistry().size());
        this.context.getEndpoint("mock:foo");
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        Endpoint prototype = this.context.getCamelContextExtension().getPrototypeEndpoint("mock:bar");
        Assertions.assertNotNull((Object)prototype);
        MockEndpoint bar = EndpointPrototypeTest.assertIsInstanceOf(MockEndpoint.class, prototype);
        Assertions.assertTrue((boolean)bar.getStatus().isStarted());
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.context.getEndpoint("mock:foo2");
        Assertions.assertEquals((int)2, (int)this.context.getEndpointRegistry().size());
        this.context.stop();
        Assertions.assertFalse((boolean)bar.getStatus().isStopped());
        bar.stop();
        Assertions.assertTrue((boolean)bar.getStatus().isStopped());
        Assertions.assertEquals((int)2, (int)endpoints.size());
        Assertions.assertEquals((Object)"mock://foo", (Object)((Endpoint)endpoints.get(0)).getEndpointUri());
        Assertions.assertEquals((Object)"mock://foo2", (Object)((Endpoint)endpoints.get(1)).getEndpointUri());
    }
}

